/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.data.repository;

import com.android.files.domain.mapper.FileDataMapper;
import com.android.files.domain.model.FileData;
import com.android.files.domain.util.AndroidFilesHandler;
import com.android.files.domain.util.BinaryDataService;
import com.android.files.domain.util.BinaryServiceFactory;
import com.dto.LoginDto;
import com.utility.DbConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;

public class PictureInfoRepo {
    private final DbConnection dbConnection;
    private final LoginDto login;

    public PictureInfoRepo(DbConnection dbConnection, LoginDto login) {
        this.dbConnection = dbConnection;
        this.login = login;
    }

    public List<Map<String, Object>> generateJson(String sql) {
        if (sql == null) {
            return Collections.emptyList();
        }
        List fileDataList = this.dbConnection.getJdbcTemplate(this.login).query(sql, (RowMapper)new FileDataMapper());
        try {
            new AndroidFilesHandler(this.login, AndroidFilesHandler.PictureType.Customer).deleteUnusedFiles(fileDataList.stream().map(FileData::fetchIdWithExtension).collect(Collectors.toList()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BinaryDataService dataService = BinaryServiceFactory.getDataService((DbConnection)this.dbConnection, (LoginDto)this.login);
        return fileDataList.stream().peek(data -> {
            if (data.getFileSize() > -1L) {
                return;
            }
            data.setFileSize(dataService.getSize(data));
        }).filter(data -> data.getFileSize() > 0L).map(FileData::toMap).collect(Collectors.toList());
    }
}

